<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.9.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

?>

<?php do_action('woocommerce_before_customer_login_form'); ?>

<div class="grid">

	<span class="grid__item one-twelfth">&nbsp;</span>

	<div class="calafate-checkout grid__item ten-twelfths palm--one-whole">

		<ul class="calafate-checkout-navigation">

			<li class="active">
				<span class="title"><?php esc_html_e('Login', 'calafate'); ?></span>
				<span class="line"></span>
				<?php echo calafate_svg('login', 'icon'); ?>
			</li>

			<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')): ?>

				<li>
					<span class="title"><?php esc_html_e('Register', 'calafate'); ?></span>
					<span class="line"></span>
					<?php echo calafate_svg('register', 'icon register'); ?>
				</li>

			<?php endif; ?>

		</ul>

		<div class="calafate-checkout-content carousel">

			<div class="carousel-cell">

				<div class="wrapper">
					<div class="wrapper-second">

						<header class="archive-header active">
							<h1><?php esc_html_e('Login', 'calafate'); ?></h1>
							<h3><?php esc_html_e('Insert your details', 'calafate'); ?></h3>
						</header>

						<form method="post"
							class="login woocommerce-checkout one-half lap--two-thirds palm--one-whole ccform">

							<?php do_action('woocommerce_login_form_start'); ?>

							<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
								<label
									for="username"><?php esc_html_e('Username or email address', 'calafate'); ?>&nbsp;<span
										class="required">*</span></label>
								<input type="text" class="woocommerce-Input woocommerce-Input--text input-text"
									name="username" id="reg_username" autocomplete="username"
									value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"
									required aria-required="true" /><?php // @codingStandardsIgnoreLine ?>
							</p>
							<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
								<label for="password"><?php esc_html_e('Password', 'calafate'); ?>&nbsp;<span
										class="required">*</span></label>
								<input class="woocommerce-Input woocommerce-Input--text input-text" type="password"
									name="password" id="password" autocomplete="current-password" required
									aria-required="true" />
							</p>

							<?php do_action('woocommerce_login_form'); ?>

							<p class="form-row">
								<label for="rememberme"
									class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
									<input class="woocommerce-Input woocommerce-Input--checkbox" name="rememberme"
										type="checkbox" id="rememberme" value="forever" />
									<span><?php esc_html_e('Remember me', 'calafate'); ?></span>
								</label>
							</p>

							<p class="form-row">
								<?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
								<input type="submit" class="woocommerce-Button button" name="login"
									value="<?php esc_attr_e('Login', 'calafate'); ?>" />
							</p>

							<p class="woocommerce-LostPassword lost_password">
								<a
									href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php esc_html_e('Lost your password?', 'calafate'); ?></a>
							</p>

							<?php do_action('woocommerce_login_form_end'); ?>

						</form>

					</div>

				</div>

			</div>

			<?php if ('yes' === get_option('woocommerce_enable_myaccount_registration')): ?>

				<div class="carousel-cell">

					<div class="wrapper">
						<div class="wrapper-second">

							<header class="archive-header active">
								<h1><?php esc_html_e('Register', 'calafate'); ?></h1>
								<h3><?php esc_html_e('Create an account', 'calafate'); ?></h3>
							</header>

							<form method="post"
								class="register woocommerce-form woocommerce-form-register woocommerce-checkout register one-half lap--two-thirds palm--one-whole ccform"
								<?php do_action('woocommerce_register_form_tag'); ?>>

								<?php do_action('woocommerce_register_form_start'); ?>

								<?php if ('no' === get_option('woocommerce_registration_generate_username')): ?>

									<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
										<label for="reg_username"><?php esc_html_e('Username', 'calafate'); ?>&nbsp;<span
												class="required" aria-hidden="true">*</span></label>
										<input type="text" class="woocommerce-Input woocommerce-Input--text input-text"
											name="username" autocomplete="username" id="reg_username"
											value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
									</p>

								<?php endif; ?>

								<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
									<label for="reg_email"><?php esc_html_e('Email address', 'calafate'); ?>&nbsp;<span
											class="required" aria-hidden="true">*</span></label>
									<input utocomplete="email" type="email"
										class="woocommerce-Input woocommerce-Input--text input-text" name="email"
										id="reg_email"
										value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
								</p>

								<?php if ('no' === get_option('woocommerce_registration_generate_password')): ?>

									<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
										<label for="reg_password"><?php esc_html_e('Password', 'calafate'); ?>&nbsp;<span
												class="required" aria-hidden="true">*</span></label>
										<input type="password" class="woocommerce-Input woocommerce-Input--text input-text"
											autocomplete="new-password" name="password" id="reg_password" />
									</p>

								<?php endif; ?>

								<?php do_action('woocommerce_register_form'); ?>
								<?php do_action('register_form'); ?>

								<p class="woocommerce-form-row form-row">
									<?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
									<input type="submit" class="woocommerce-Button button" name="register"
										value="<?php esc_attr_e('Register', 'calafate'); ?>" />
								</p>

								<?php do_action('woocommerce_register_form_end'); ?>

							</form>

						</div>
					</div>

				</div>

			<?php endif; ?>

		</div>

	</div>

	<?php do_action('woocommerce_after_customer_login_form'); ?>

</div>